<?php
$params = array_merge(
    require __DIR__ . '/../../common/config/params.php',
    require __DIR__ . '/../../common/config/params-local.php',
    require __DIR__ . '/params.php',
    require __DIR__ . '/params-local.php'
);

return [
    'id' => 'app-admin',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'admin\controllers',
    'bootstrap' => ['log'],
    'language' => 'id',
    'modules' => [
        'milestone' => [
            'class' => 'admin\modules\milestone\Milestone',
        ],
        'brand' => [
            'class' => 'admin\modules\brand\Brand',
        ],
        'article' => [
            'class' => 'admin\modules\article\Article',
        ],
        'facility' => [
            'class' => 'admin\modules\facility\Facility',
        ],
        'distribution' => [
            'class' => 'admin\modules\distribution\Distribution',
        ],
        'certification' => [
            'class' => 'admin\modules\certification\Certification',
        ],
        'subsidiary' => [
            'class' => 'admin\modules\subsidiary\Subsidiary',
        ],
        'slide' => [
            'class' => 'admin\modules\slide\Slide',
        ],
        'productcategory' => [
            'class' => 'admin\modules\productcategory\Productcategory',
        ],
		'setting' => [
            'class' => 'admin\modules\setting\Setting',
        ],
        'gridview' =>  [
            'class' => '\kartik\grid\Module'
        ],
	],
    'components' => [
        'request'=>[
			'cookieValidationKey' => '[ruiqwybnddiogj786789hzcassdas9dasdjufi]',
			'csrfParam' => '_adminCSRF',
			'class' => 'common\components\Request',
			'web'=> '/admin/web',
			'adminUrl' => '/admin',
            'enableCsrfValidation' => false
		],
        'user' => [
			'identityClass' => 'common\models\User',
			'enableAutoLogin' => false,
			'identityCookie' => [
				'name' => '_adminUser', // unique for admin
			]
		],
        'session' => [
			'name' => 'PHPBACKSESSID',
			'savePath' => sys_get_temp_dir(),
		],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
            ],
        ],
        'authManager'=>
		[
			'class'=>'yii\rbac\DbManager',
			'defaultRoles'=>['guest'],
		],
		'assetManager' => [
            'bundles' => [
                'yii\web\JqueryAsset' => [
                    'sourcePath' => null,
                    'basePath' => '@webroot',
                    'baseUrl' => '@web',
                    'js' => [
                        'plugins/jquery/jquery.min.js',
                    ],
                    'jsOptions' => [ 'position' => \yii\web\View::POS_HEAD ],
                ],
                'yii\bootstrap\BootstrapAsset' => [
                    'css' => [],
                ],
            ],
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            'viewPath' => '@common/mail',
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'us17.sharehostserver.com',//'newton.dnshostnetwork.com',
                'username' => 'info@marnova.co.id',
                'password' => 'marnova_123',
                'port' => '465',
                'encryption' => 'ssl',
                // 'host' => 'smtp.gmail.com',
                // 'username' => 'fauzimuhammad153@gmail.com',//'henry.gunawan.1986@gmail.com',
                // 'password' => 'Wonosari99',//'m26404020',
                // 'port' => '587',
                // 'encryption' => 'tls',
                'streamOptions' => [ 
                    'ssl' => [ 
                        'allow_self_signed' => true,
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                    ],
                ],
            ],
        ],
    ],
    'params' => $params,
];
