<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Member;

/**
 * MemberSearch represents the model behind the search form of `common\models\Member`.
 */
class MemberSearch extends Member
{
    public $start_date, $end_date;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'province_id', 'city_id', 'member_is_verified', 'created_by', 'updated_by', 'is_deleted'], 'integer'],
            [['member_email', 'member_password', 'member_fullname', 'member_address', 'province_name', 'city_name', 'member_phone', 'member_verification_code', 'member_status', 'created_on', 'updated_on', 'start_date', 'end_date'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Member::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'defaultOrder' => ['member_fullname' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'province_id' => $this->province_id,
            'city_id' => $this->city_id,
            'member_is_verified' => $this->member_is_verified,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_on' => $this->created_on,
            'updated_on' => $this->updated_on,
            'is_deleted' => 0,
        ]);

        $query->andFilterWhere(['like', 'member_email', $this->member_email])
            ->andFilterWhere(['like', 'member_password', $this->member_password])
            ->andFilterWhere(['like', 'member_fullname', $this->member_fullname])
            ->andFilterWhere(['like', 'member_address', $this->member_address])
            ->andFilterWhere(['like', 'province_name', $this->province_name])
            ->andFilterWhere(['like', 'city_name', $this->city_name])
            ->andFilterWhere(['like', 'member_phone', $this->member_phone])
            ->andFilterWhere(['like', 'member_verification_code', $this->member_verification_code])
            ->andFilterWhere(['like', 'member_status', $this->member_status]);

        if ($this->start_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date))
            $query->andWhere('DATE(created_on) >= "'.date("Y-m-d", strtotime($this->start_date)).'"');
        if ($this->end_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date))
            $query->andWhere('DATE(created_on) <= "'.date("Y-m-d", strtotime($this->end_date)).'"');

        return $dataProvider;
    }
}
