<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Milestone;

/**
 * MilestoneSearch represents the model behind the search form of `common\models\Milestone`.
 */
class MilestoneSearch extends Milestone
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'milestone_order'], 'integer'],
            [['milestone_year', 'milestone_description', 'milestone_image', 'milestone_position'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Milestone::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['milestone_order' => SORT_ASC],
                'attributes' => [
                    'milestone_description',
                    'milestone_position',
                    'milestone_order',
                    'milestone_year' => [
                        'asc' => ['CAST(milestone_year AS UNSIGNED)' => SORT_ASC],
                        'desc' => ['CAST(milestone_year AS UNSIGNED)' => SORT_DESC]
                    ]
                ]
            ]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'milestone_order' => $this->milestone_order,
        ]);

        $query->andFilterWhere(['like', 'milestone_year', $this->milestone_year])
            ->andFilterWhere(['like', 'milestone_description', $this->milestone_description])
            ->andFilterWhere(['like', 'milestone_image', $this->milestone_image])
            ->andFilterWhere(['like', 'milestone_position', $this->milestone_position]);

        return $dataProvider;
    }
}
