<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\PaymentConfirmation;

/**
 * PaymentConfirmationSearch represents the model behind the search form of `common\models\PaymentConfirmation`.
 */
class PaymentConfirmationSearch extends PaymentConfirmation
{
    public $order_code, $order_date, $start_date, $end_date, $start_date2, $end_date2;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'order_id'], 'integer'],
            [['confirmation_amount'], 'number'],
            [['confirmation_date', 'confirmation_sender_name', 'confirmation_email', 'confirmation_proof_filename', 'confirmation_status', 'order_code', 'order_date', 'start_date', 'end_date', 'start_date2', 'end_date2'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PaymentConfirmation::find();
        $query->joinWith(['order AS order']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'confirmation_amount',
                    'confirmation_date',
                    'confirmation_sender_name',
                    'confirmation_email',
                    'confirmation_status',
                    'order_code' => [
                        'asc' => ['order.order_code' => SORT_ASC],
                        'desc' => ['order.order_code' => SORT_DESC],
                    ],
                    'order_date' => [
                        'asc' => ['order.order_date' => SORT_ASC],
                        'desc' => ['order.order_date' => SORT_DESC],
                    ],
                ],
                'defaultOrder' => ['confirmation_date' => SORT_DESC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'order_id' => $this->order_id,
            'confirmation_amount' => $this->confirmation_amount,
            'order.is_deleted' => 0,
        ]);

        $query->andFilterWhere(['like', 'confirmation_date', $this->confirmation_date])
            ->andFilterWhere(['like', 'confirmation_sender_name', $this->confirmation_sender_name])
            ->andFilterWhere(['like', 'confirmation_email', $this->confirmation_email])
            ->andFilterWhere(['like', 'confirmation_proof_filename', $this->confirmation_proof_filename])
            ->andFilterWhere(['like', 'confirmation_status', $this->confirmation_status])
            ->andFilterWhere(['like', 'order.order_code', $this->order_code]);

        if ($this->start_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date))
            $query->andWhere('DATE(confirmation_date) >= "'.date("Y-m-d", strtotime($this->start_date)).'"');
        if ($this->end_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date))
            $query->andWhere('DATE(confirmation_date) <= "'.date("Y-m-d", strtotime($this->end_date)).'"');

        if ($this->start_date2 != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date2))
            $query->andWhere('DATE(order.order_date) >= "'.date("Y-m-d", strtotime($this->start_date2)).'"');
        if ($this->end_date2 != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date2))
            $query->andWhere('DATE(order.order_date) <= "'.date("Y-m-d", strtotime($this->end_date2)).'"');

        return $dataProvider;
    }
}
