<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ProductAttributeGroup;

/**
 * ProductAttributeGroupSearch represents the model behind the search form of `common\models\ProductAttributeGroup`.
 */
class ProductAttributeGroupSearch extends ProductAttributeGroup
{
    public $product_name, $group_label;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'product_id', 'group_label_id'], 'integer'],
            [['attribute_group_title', 'product_name', 'group_label'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ProductAttributeGroup::find();
        $query->joinWith(['product AS product', 'groupLabel AS label']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'attributes' => [
                    'attribute_group_title',
                    'product_name' => [
                        'asc' => ['product.product_name' => SORT_ASC],
                        'desc' => ['product.product_name' => SORT_DESC],
                    ],
                    'group_label' => [
                        'asc' => ['label.group_label' => SORT_ASC],
                        'desc' => ['label.group_label' => SORT_DESC],
                    ],
                ],
                'defaultOrder' => ['product_name' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'product_id' => $this->product_id,
            'group_label_id' => $this->group_label_id,
        ]);

        $query->andFilterWhere(['like', 'attribute_group_title', $this->attribute_group_title])
            ->andFilterWhere(['like', 'label.group_label', $this->group_label])
            ->andFilterWhere(['like', 'product.product_name', $this->product_name]);

        return $dataProvider;
    }
}
