<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\ProductCategory;

/**
 * ProductCategorySearch represents the model behind the search form of `common\models\ProductCategory`.
 */
class ProductCategorySearch extends ProductCategory
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'product_category_parent_id', 'is_deleted'], 'integer'],
            [['product_category_name', 'product_category_slug', 'product_category_image'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ProductCategory::find();
        $query->alias('category');
        $query->joinWith(['parent AS parent']);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['parent.product_category_name' => SORT_ASC, 'category.product_category_name' => SORT_ASC],
                'attributes' => [
                    'category.product_category_name',
                    'product_category_name',
                    'product_category_slug',
                    'parent.product_category_name',
                    'product_category_parent_id' => [
                        'asc' => ['parent.product_category_name' => SORT_ASC],
                        'desc' => ['parent.product_category_name' => SORT_DESC],
                    ]
                ],
            ]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'product_category_parent_id' => $this->product_category_parent_id,
            'is_deleted' => $this->is_deleted,
        ]);

        $query->andFilterWhere(['like', 'category.product_category_name', $this->product_category_name])
            ->andFilterWhere(['like', 'product_category_slug', $this->product_category_slug])
            ->andFilterWhere(['like', 'product_category_image', $this->product_category_image]);

        return $dataProvider;
    }
}
