<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Slide;

/**
 * SlideSearch represents the model behind the search form of `common\models\Slide`.
 */
class SlideSearch extends Slide
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'slide_order', 'slide_is_active'], 'integer'],
            [['slide_title', 'slide_desc', 'slide_color', 'slide_image_filename', 'slide_image_mobile_filename', 'slide_image_logo_filename', 'slide_url', 'slide_url_label', 'slide_url_icon', 'slide_url2', 'slide_url_label2', 'slide_url_icon2'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Slide::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['slide_order' => SORT_ASC]
            ]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'slide_order' => $this->slide_order,
            'slide_is_active' => $this->slide_is_active,
        ]);

        $query->andFilterWhere(['like', 'slide_title', $this->slide_title])
            ->andFilterWhere(['like', 'slide_desc', $this->slide_desc])
            ->andFilterWhere(['like', 'slide_color', $this->slide_color])
            ->andFilterWhere(['like', 'slide_image_filename', $this->slide_image_filename])
            ->andFilterWhere(['like', 'slide_image_mobile_filename', $this->slide_image_mobile_filename])
            ->andFilterWhere(['like', 'slide_image_logo_filename', $this->slide_image_logo_filename])
            ->andFilterWhere(['like', 'slide_url', $this->slide_url])
            ->andFilterWhere(['like', 'slide_url_label', $this->slide_url_label])
            ->andFilterWhere(['like', 'slide_url_icon', $this->slide_url_icon])
            ->andFilterWhere(['like', 'slide_url2', $this->slide_url2])
            ->andFilterWhere(['like', 'slide_url_label2', $this->slide_url_label2])
            ->andFilterWhere(['like', 'slide_url_icon2', $this->slide_url_icon2]);

        return $dataProvider;
    }
}
