<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Subsidiary;

/**
 * SubsidiarySearch represents the model behind the search form of `common\models\Subsidiary`.
 */
class SubsidiarySearch extends Subsidiary
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'subsidiary_order'], 'integer'],
            [['subsidiary_name', 'subsidiary_desc'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Subsidiary::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort' => [
                'defaultOrder' => ['subsidiary_order' => SORT_ASC]
            ]
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'subsidiary_order' => $this->subsidiary_order,
        ]);

        $query->andFilterWhere(['like', 'subsidiary_name', $this->subsidiary_name])
            ->andFilterWhere(['like', 'subsidiary_desc', $this->subsidiary_desc]);

        return $dataProvider;
    }
}
