<?php

namespace admin\models;

use yii\base\Model;

/**
 * Backup
 *
 * Yii module to backup, restore databse
 *
 * @version 1.0
 * @author Shiv Charan Panjeta <shiv@toxsl.com> <shivcharan.panjeta@outlook.com>
 */
/**
 * UploadForm class.
 * UploadForm is the data structure for keeping
 */
class UploadForm extends Model
{
	public $upload_file ;

	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		if(!isset($this->scenario))
			$this->scenario = 'upload';

        /*
		return array(
				array('upload_file', 'required'),
		);
        */
        return [
            [['upload_file'], 'file', 'skipOnEmpty' => false, 'extensions' => 'sql'],
        ];
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
				'upload_file'=>'SQL Faylı',
		);
	}
	public static function label($n = 1) {
		return Yii::t('app', 'File|Files', $n);
	}
}
