<?php

namespace admin\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Voucher;

/**
 * VoucherSearch represents the model behind the search form of `common\models\Voucher`.
 */
class VoucherSearch extends Voucher
{
    public $start_date, $end_date, $start_date2, $end_date2;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'voucher_qty', 'voucher_qty_used'], 'integer'],
            [['voucher_title', 'voucher_code', 'voucher_from', 'voucher_to', 'voucher_type', 'start_date', 'end_date', 'start_date2', 'end_date2'], 'safe'],
            [['voucher_value', 'voucher_min_order'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Voucher::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => (new \common\models\Setting)->getSettingValueByName('record_per_page'),
            ],
            'sort'=> [
                'defaultOrder' => ['voucher_title' => SORT_ASC],
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'voucher_from' => $this->voucher_from,
            'voucher_to' => $this->voucher_to,
            'voucher_value' => $this->voucher_value,
            'voucher_min_order' => $this->voucher_min_order,
            'voucher_qty' => $this->voucher_qty,
            'voucher_qty_used' => $this->voucher_qty_used,
        ]);

        $query->andFilterWhere(['like', 'voucher_title', $this->voucher_title])
            ->andFilterWhere(['like', 'voucher_code', $this->voucher_code])
            ->andFilterWhere(['like', 'voucher_type', $this->voucher_type]);

        if ($this->start_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date))
            $query->andWhere('DATE(voucher_from) >= "'.date("Y-m-d", strtotime($this->start_date)).'"');
        if ($this->end_date != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date))
            $query->andWhere('DATE(voucher_from) <= "'.date("Y-m-d", strtotime($this->end_date)).'"');

        if ($this->start_date2 != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->start_date2))
            $query->andWhere('DATE(voucher_to) >= "'.date("Y-m-d", strtotime($this->start_date2)).'"');
        if ($this->end_date2 != "" && preg_match('/^(\d{2})-(\d{2})-(\d{4})$/', $this->end_date2))
            $query->andWhere('DATE(voucher_to) <= "'.date("Y-m-d", strtotime($this->end_date2)).'"');

        return $dataProvider;
    }
}
