<?php

namespace admin\modules\article\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use admin\models\ArticleCategorySearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use common\models\ArticleCategory;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class CategoryController extends BaseController
{

    public function actionIndex()
    {
		BaseController::$page_caption = 'Categories';

		$searchModel = new ArticleCategorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

  public function actionView($id)
  {
      BaseController::$page_caption = 'View Category';

      $model = $this->findModel($id);

      return $this->render('view', [
          'model' => $model
      ]);
  }

	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Category';

		$model = new ArticleCategory();

        if ($model->load(Yii::$app->request->post())) {
            
            $imagename = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->category_image   = $imagename.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/articles/'.$imagename.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Categories '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Category';

  		$model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {
            
            $imagename = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->category_image   = $imagename.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/articles/'.$imagename.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Categories '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $model = $this->findModel($id);
        $model->is_deleted = 1;
        $model->save();

        Yii::$app->session->setFlash('success', 'Category '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the ArticleCategory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ArticleCategory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ArticleCategory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
