<?php

namespace admin\modules\article\controllers;

use Yii;
use app\components\BaseController;
use common\models\Article;
use common\models\ArticleCategory;
use common\components\CurrencyComponent;
use common\components\ErrorGenerateComponent;
use admin\models\ArticleSearch;
use admin\components\LabelComponent;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
    {
        BaseController::$page_caption = 'Articles';

        $searchModel = new ArticleSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        BaseController::$page_caption = 'View Article';

        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model
        ]);
    }

	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Article';

		$model = new Article();
        $model->loadDefaultValues();

        $model->created_on = date("d-m-Y");

        $model->ajaxRequests();
        
        if ($model->load(Yii::$app->request->post())) {

            $noProblem = true;

            $trans = Yii::$app->db->beginTransaction();

            $model->article_short_description = !empty($model->article_short_description) ? nl2br($model->article_short_description): NULL;
            $model->created_on = !empty($model->created_on) ? date("Y-m-d", strtotime($model->created_on)).' '.date("H:i:s") : date("Y-m-d H:i:s");
            $model->article_slug = empty($model->article_slug) ? $model->slugify($model->article_title) : $model->slugify($model->article_slug);

            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->article_featured_image   = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/articles/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                if ($noProblem) {
                    $trans->commit();
                    Yii::$app->session->setFlash('success', 'Article '.LabelComponent::SUCCESS_SAVE);
                    return $this->redirect(['index']);
                }
            }

            $model->article_short_description = !empty($model->article_short_description) ? strip_tags($model->article_short_description): NULL;
            $model->created_on = !empty($model->created_on) ? date("d-m-Y") : NULL;

            $trans->rollback();
        }

        $categories = ArticleCategory::find()->andWhere('is_deleted=0')->orderBy(['category_name' => SORT_ASC])->all();

        return $this->render('form', [
           'model' => $model,
           'categories' => $categories,
           'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
		BaseController::$page_caption = 'Update Article';

		$model = $this->findModel($id);

        $model->article_short_description = !empty($model->article_short_description) ? strip_tags($model->article_short_description): NULL;
        $model->created_on = !empty($model->created_on) ? date("d-m-Y", strtotime($model->created_on)) : NULL;

        $model->ajaxRequests();
  
        if ($model->load(Yii::$app->request->post())) {

            $noProblem = true;

            $trans = Yii::$app->db->beginTransaction();

            $model->article_short_description = !empty($model->article_short_description) ? nl2br($model->article_short_description): NULL;
            $model->created_on = !empty($model->created_on) ? date("Y-m-d", strtotime($model->created_on)).' '.date("H:i:s") : date("Y-m-d H:i:s");
            $model->article_slug = empty($model->article_slug) ? $model->slugify($model->article_title) : $model->slugify($model->article_slug);

            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->article_featured_image   = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/articles/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                if ($noProblem) {
                    $trans->commit();
                    Yii::$app->session->setFlash('success', 'Article '.LabelComponent::SUCCESS_SAVE);
                    return $this->redirect(['index']);
                }
            }

            $model->article_short_description = !empty($model->article_short_description) ? strip_tags($model->article_short_description): NULL;
            $model->created_on = !empty($model->created_on) ? date("d-m-Y") : NULL;

            $trans->rollback();
        }

        $categories = ArticleCategory::find()->andWhere('is_deleted=0')->orderBy(['category_name' => SORT_ASC])->all();
        
        return $this->render('form', [
           'model' => $model,
           'categories' => $categories,
           'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $model = $this->findModel($id);
        $model->is_deleted = "1";
        if ($model->update(false)) {
            Yii::$app->session->setFlash('success', 'Article '.LabelComponent::SUCCESS_DELETE);
        } else {
            Yii::$app->session->setFlash('danger', 'Article '.LabelComponent::ERROR_DELETE);
        }

        return $this->redirect(['index']);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Article::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
