<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ArticleCategory;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-content">
				<div class="card-body">
                    <label><?=(new ArticleCategory)->getAttributeLabel('category_image')?></label><br/>
                    <?= $form->field($model, 'image')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->category_image)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/articlecategories/".$model->category_image);
                            if(file_exists("../../uploads/articlecategories/".$model->category_image)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
					<?=$form->field($model, 'category_name')->textInput(['class' => 'form-control input-sm']);?>
					<?=$form->field($model, 'category_color')->textInput(['class' => 'form-control input-sm']);?>
				</div>
			</div>
		</div>
	</div>
</section>

<?php ActiveForm::end(); ?>
