<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductImage;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
    echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="table-responsive">
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            'filterModel' => $searchModel,
                            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                [
                                    'attribute' => 'category_image',
                                    'format' => 'raw',
                                    'value' => function($model) {
                                        $urlImage = str_replace("/admin", '', Url::base(true)."/uploads/articlecategories/".$model->category_image);
                                        $image = "";
                                        if(file_exists("../../uploads/articlecategories/".$model->category_image)){
                                            $image = "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/articlecategories/').$model->category_image."' alt='' style='max-width: 150px; max-height: 150px;'/>";
                                        }

                                        return $image;
                                    },
                                    'filter' => false,
                                ],
                                'category_name',
                                [
                                    'attribute' => 'category_color',
                                    'value' => function($model) {
                                        return '<div style="display: flex; align-items: center;"><div style="background-color: '.$model->category_color.'; width: 20px; height: 20px; margin-right: 5px; border: 1px solid #000;"></div> <div style="color: '.$model->category_color.'">'.$model->category_color.'</div></div>';
                                    },
                                    'format' => 'raw',
                                    'filter' => false,
                                ],
                                [
                                    'class' => 'yii\grid\ActionColumn',
                                    'header'   => 'Actions',
                                    'template' => '<div style="white-space: nowrap;">{update}{delete}</div>',
                                    'buttons'  => [
                                        'update' => function ($url, $model) {    
                                            $url = Url::to(['update', 'id' => $model->id]);
                                            return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                        },
                                        'delete' => function ($url, $model) {
                                            $url = Url::to(['delete', 'id' => $model->id]);
                                            return Html::a(
                                                '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                '#',
                                                [
                                                    'title' => Yii::t('yii', 'Delete'),
                                                    'aria-label' => Yii::t('yii', 'Delete'),
                                                    'onclick' => "deleteclick('".$url."');"
                                                ]
                                            );
                                        }
                                    ],
                                    'headerOptions' => ['style' => 'width:7%'],
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>