<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Article;
use common\models\ArticleCategory;
use common\models\User;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-md-8">
        <div class="card">
			<div class="card-header">
				<h4 class="card-title">Main Info</h4>
			</div>
			<div class="card-content">
				<div class="card-body pt-0">
					<?= $form->field($model, 'article_title')->textInput(['class'=>'form-control input-sm']) ?>
					<?= $form->field($model, 'article_slug')->textInput(['class'=>'form-control input-sm']) ?>
					<?= $form->field($model, 'article_short_description')->textArea(['class'=>'form-control input-sm', 'rows' => 4]) ?>
					<?= $form->field($model, 'article_description')->textInput(['class' => 'form-control input-sm tinymce']);?>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<div class="card-content">
				<div class="card-body">
					<?= $form->field($model, 'created_on')->textInput(['class' => 'form-control input-sm datepicker'])?>
					<?= $form->field($model, 'article_status')->dropDownList($model->getStatusLabels(), ['class' => 'form-control input-sm']);?>
				</div>
			</div>
		</div>
		<div class="card">
			<div class="card-header">
				<h4 class="card-title">Category</h4>
			</div>
			<div class="card-content">
				<div class="card-body pt-0">
					<?= $form->field($model, 'article_category_id')->dropDownList(ArrayHelper::map($categories, 'id', 'category_name'), ['prompt' => LabelComponent::CHOOSE_DROPDOWN, 'class' => 'form-control input-sm'])->label(false);?>
				</div>
			</div>
		</div>
		<div class="card">
			<div class="card-header">
				<h4 class="card-title">Image</h4>
			</div>
			<div class="card-content">
				<div class="card-body pt-0">
					<?= $form->field($model, 'image')->fileInput()->label(false)?>
					<?php
						if(!empty($model->article_featured_image)){
							$urlImage = str_replace("admin/", '', Url::base(true)."/uploads/articles/".$model->article_featured_image);
							if(file_exists("../../uploads/articles/".$model->article_featured_image)){
								echo Html::img($urlImage, ['style' => 'max-height: 200px; max-width: 100%;'])."<br>";
								echo "<i>Upload gambar baru untuk menggantikan yang sekarang</i>";
							}
						}
					?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php ActiveForm::end(); ?>
<script type="text/javascript">
$(document).ready(function(){
	$("#article-article_title").blur(function(){
        var title = $(this).val();
        if (title != "") {
            $.post('<?=Yii::$app->request->getAbsoluteUrl();?>', {'mode': 'generateslug', 'article_title': title}, function(response){
                $("#article-article_slug").val(response);
            }, 'json');
        }
    });
});
</script>