<?php

namespace admin\modules\brand\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use admin\components\DeliveryCostComponent;
use admin\models\BrandSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use common\models\Brand;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Brand';

		$searchModel = new BrandSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

    public function actionView($id)
    {
        BaseController::$page_caption = 'View Brand';

        $model = $this->findModel($id);

        return $this->render('view', [
            'model' => $model
        ]);
    }

	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Brand';

		$model = new Brand();
        $model->loadDefaultValues();
        $model->brand_order = $model->getLatestOrder() + 1;

        if ($model->load(Yii::$app->request->post())) {
            
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->brand_logo = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/brands/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Brand';

  		$model = $this->findModel($id);
      
        if ($model->load(Yii::$app->request->post())) {
            
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->brand_logo = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/brands/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();

        Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_DELETE);
      
        return $this->redirect(['index']);
	}

    public function actionChangeorder($id, $type)
    {
        $model = $this->findModel($id);
        if ($type == 'up' && $model->brand_order > 1) {
            $brandBefore = Brand::find()->andWhere('brand_order < :order', [':order' => $model->brand_order])->orderBy(['brand_order' => SORT_DESC])->one();
            if ($brandBefore->brand_order == $model->brand_order - 1) {
                $brandBefore->brand_order = $model->brand_order;
                $brandBefore->save();
            }
            $model->brand_order--;
            $model->save();
        } else if ($type == 'down') {
            $brands = Brand::find()->all();
            if ($model->brand_order < count($brands)) {
                $brandAfter = Brand::find()->andWhere('brand_order > :order', [':order' => $model->brand_order])->orderBy(['brand_order' => SORT_ASC])->one();
                if ($brandAfter->brand_order == $model->brand_order + 1) {
                    $brandAfter->brand_order = $model->brand_order;
                    $brandAfter->save();
                }
                $model->brand_order++;
                $model->save();
            }
        }

        return $this->redirect(['index']);
    }

    /**
     * Finds the Brand model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Brand the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Brand::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
