<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Brand;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/voucher/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => true]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <label><?=(new Brand)->getAttributeLabel('brand_logo')?></label><br/>
                    <?= $form->field($model, 'image')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->brand_logo)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/brands/".$model->brand_logo);
                            if(file_exists("../../uploads/brands/".$model->brand_logo)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php ActiveForm::end(); ?>