<?php

namespace admin\modules\certification\controllers;

use Yii;
use app\components\BaseController;
use admin\models\CertificationSearch;
use admin\components\LabelComponent;
use common\models\Certification;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Certification';

		$searchModel = new CertificationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

  	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Certification';

		$model = new Certification;
        $model->loadDefaultValues();

        if ($model->load(Yii::$app->request->post())) {

            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->certification_logo = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/certifications/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Certification '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Certification';

  		$model = $this->findModel($id);
      
        if ($model->load(Yii::$app->request->post())) {
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->certification_logo = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/certifications/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Certification '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();
      
        Yii::$app->session->setFlash('success', 'Certification '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the Certification model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Certification the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Certification::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
