<?php

namespace admin\modules\distribution\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\IndoDistribution;
use common\models\Order;
use common\models\IndoDistributionDetail;
use admin\components\DeliveryCostComponent;
use admin\models\IndoDistributionSearch;
use admin\models\OrderSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
	    BaseController::$page_caption = 'Local Distribution';

		$searchModel = new IndoDistributionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

    public function actionCreate()
	{
        BaseController::$page_caption = 'Add Local Distribution';

		$model = new IndoDistribution();

        if ($model->load(Yii::$app->request->post())) {

            $noProblem = true;

            $trans = Yii::$app->db->beginTransaction();
            
            $items = isset($_POST['items']) ? $_POST['items'] : [];

            if ($model->save()) {
                $noItem = true;
                foreach($items as $item) {
                    if ($item['IndoDistributionDetail']['dist_city_name'] != "") {
                        $noItem = false;

                        $modelItem = new IndoDistributionDetail;
                        $modelItem->attributes = $item['IndoDistributionDetail'];
                        $modelItem->indo_distribution_id = $model->id;
                        if (!$modelItem->save()) {
                            $noProblem = false;
                            $message = ErrorGenerateComponent::generateErrorLabels($modelItem->getErrors());
                            Yii::$app->session->setFlash('danger', 'Failed to save detail.'.$message);
                            break;
                        }
                    }
                }

                if ($noItem) {
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', 'At least one city is needed.');
                }

                if ($noProblem) {
                    $trans->commit();
                    Yii::$app->session->setFlash('success', 'Local Distribution '.LabelComponent::SUCCESS_SAVE);
                    return $this->redirect(['index']);
                }
            }

            $trans->rollback();
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
            'items' => isset($items) ? $items : [],
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Local Distribution';

  		$model = $this->findModel($id);

        foreach($model->indoDistributionDetails as $i => $detail) {
            $items[$i]['IndoDistributionDetail'] = [
                'dist_city_name' => $detail->dist_city_name,
            ];
        }

        if ($model->load(Yii::$app->request->post())) {

            $noProblem = true;

            $trans = Yii::$app->db->beginTransaction();
            
            $items = isset($_POST['items']) ? $_POST['items'] : [];

            if ($model->save()) {
                
                IndoDistributionDetail::deleteAll('indo_distribution_id=:id', [':id' => $id]);

                $noItem = true;
                foreach($items as $item) {
                    if ($item['IndoDistributionDetail']['dist_city_name'] != "") {
                        $noItem = false;

                        $modelItem = new IndoDistributionDetail;
                        $modelItem->attributes = $item['IndoDistributionDetail'];
                        $modelItem->indo_distribution_id = $model->id;
                        if (!$modelItem->save()) {
                            $noProblem = false;
                            $message = ErrorGenerateComponent::generateErrorLabels($modelItem->getErrors());
                            Yii::$app->session->setFlash('danger', 'Failed to save detail.'.$message);
                            break;
                        }
                    }
                }

                if ($noItem) {
                    $noProblem = false;
                    Yii::$app->session->setFlash('danger', 'At least one city is needed.');
                }

                if ($noProblem) {
                    $trans->commit();
                    Yii::$app->session->setFlash('success', 'Local Distribution '.LabelComponent::SUCCESS_UPDATE);
                    return $this->redirect(['index']);
                }
            }

            $trans->rollback();
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
            'items' => isset($items) ? $items : [],
        ]);
	}

	public function actionDelete($id)
	{
        IndoDistributionDetail::deleteAll('indo_distribution_id=:id', [':id' => $id]);

        $this->findModel($id)->delete();

        Yii::$app->session->setFlash('success', 'Local Distribution '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = IndoDistribution::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
