<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\PaymentConfirmation;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/paymentconfirmation/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <?= $form->field($model, 'dist_province_name')->textInput(['class'=>'form-control input-sm']) ?>
                    <?= $form->field($model, 'dist_col')->textInput(['type' => 'number', 'class'=>'form-control input-sm']) ?>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Cities</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hovered table-item">
                            <thead>
                                <tr>
                                    <th>City Name</th>
                                    <th style="width: 1px"></th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach($items as $i => $item):?>
                                <tr class="row-item" id="row-<?=$i?>">
                                    <td><?=Html::textInput('items['.$i.'][IndoDistributionDetail][dist_city_name]', $item[$i]['IndoDistributionDetail']['dist_city_name'], ['class' => 'form-control input-sm dist-city-name'])?></td>
                                    <td><button type="button" class="btn btn-outline-danger btn-sm btn-remove"><i class="la la-trash"></i></button></td>
                                </tr>
                            <?php endforeach;?>
                            </tbody>
                        </table>
                        <button type="button" class="btn btn-sm btn-outline-info btn-add-row"><i class="la la-plus"></i> Add</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>
<?php echo Yii::$app->view->render('_templateitem'); ?>

<script type="text/javascript">
function addRow()
{
	var index = 0;
	if (typeof $(".table-item .row-item").last().attr("id") != 'undefined')
		index = parseInt($(".table-item .row-item").last().attr("id").split("-")[1]) + 1;

	var clone = $(".table-template .row-item").clone().attr("id", "row-"+index);
	
	clone.html(function(i, oldTr) {return oldTr.replace(/\{index}/g, index);});

	$(".table-item tbody").append(clone);
}

$(document).on("click", ".btn-remove", function(){
	var tr = $(this).closest("tr");
	tr.remove();
});

$(document).ready(function(){
    $(".btn-add-row").click(function(){
		addRow();
	});
});
</script>