<?php

namespace admin\modules\facility\controllers;

use Yii;
use app\components\BaseController;
use admin\models\FacilitySearch;
use admin\components\LabelComponent;
use common\models\Facility;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Facility';

		$searchModel = new FacilitySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

  	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Facility';

		$model = new Facility;
        $model->loadDefaultValues();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Facility '.LabelComponent::SUCCESS_SAVE);
            return $this->redirect(['index']);
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Facility';

  		$model = $this->findModel($id);
      
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Facility '.LabelComponent::SUCCESS_UPDATE);
            return $this->redirect(['index']);
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();
      
        Yii::$app->session->setFlash('success', 'Facility '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the Facility model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Facility the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Facility::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
