<?php

namespace admin\modules\milestone\controllers;

use Yii;
use app\components\BaseController;
use admin\models\MilestoneSearch;
use admin\components\LabelComponent;
use common\models\Milestone;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Milestone';

		$searchModel = new MilestoneSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

  	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Milestone';

		$model = new Milestone();
        $model->loadDefaultValues();
        $model->milestone_order = $model->getLatestOrder() + 1;

        if ($model->load(Yii::$app->request->post())) {
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->milestone_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/milestones/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Milestone '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Milestone';

  		$model = $this->findModel($id);
      
        if ($model->load(Yii::$app->request->post())) {
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->milestone_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/milestones/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Milestone '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();
      
        Yii::$app->session->setFlash('success', 'Milestone '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the Milestone model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Milestone the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Milestone::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
