<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Milestone;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-content">
				<div class="card-body">
                    <label><?=(new Milestone)->getAttributeLabel('milestone_image')?></label><br/>
                    <?= $form->field($model, 'image')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->milestone_image)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/milestones/".$model->milestone_image);
                            if(file_exists("../../uploads/milestones/".$model->milestone_image)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                    <br/><br/>
					<?=$form->field($model, 'milestone_year')->textInput(['class' => 'form-control input-sm']);?>
					<?=$form->field($model, 'milestone_position')->dropDownList($model->getPositionLabel(), ['class' => 'form-control input-sm', 'prompt' => LabelComponent::CHOOSE_DROPDOWN])?>
                    <?=$form->field($model, 'milestone_description')->textArea(['class' => 'form-control input-sm tinymce']);?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php ActiveForm::end(); ?>
