<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use admin\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Category;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="table-responsive">
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            'filterModel' => $searchModel,
                            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                            'columns' => [
                                [
                                    'attribute' => 'milestone_image',
                                    'format' => 'raw',
                                    'value' => function($model) {
                                        return "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/milestones/').$model->milestone_image."' alt='' style='max-width: 200px; max-height: 150px;'/>";
                                    },
                                    'filter' => false,
                                ],
                                'milestone_year',
                                [
                                    'attribute' => 'milestone_description',
                                    'format' => 'raw',
                                ],
                                [
                                    'attribute' => 'milestone_position',
                                    'value' => function($model){
                                        return $model->getPositionLabel($model->milestone_position);
                                    },
                                    'filter' => $searchModel->getPositionLabel()
                                ],
                                [
                                    'attribute' => 'milestone_order',
                                    'filter' => false,
                                ],
                                [
                                    'class' => 'yii\grid\ActionColumn',
                                    'header'   => 'Actions',
                                    'template' => '<div style="margin-bottom: 5px; white-space: nowrap;">{update}{delete}</div><div style="white-space: nowrap;">{up}{down}</div>',
                                    'buttons'  => [
                                        'up' => function ($url, $model) {
                                            $url = Url::to(['changeorder', 'id' => $model->id, 'type' => 'up']);
                                            return Html::a('<span class="btn btn-outline-primary btn-sm"><i class="la la-arrow-up"></i></span> ', $url, ['title' => 'Naik']);
                                        },
                                        'down' => function ($url, $model) {
                                            $url = Url::to(['changeorder', 'id' => $model->id, 'type' => 'down']);
                                            return Html::a('<span class="btn btn-outline-primary btn-sm"><i class="la la-arrow-down"></i></span> ', $url, ['title' => 'Turun']);
                                        },
                                        'update' => function ($url, $model) {
                                                $url = Url::to(['update', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                        },
                                        'delete' => function ($url, $model) {
                                                $url = Url::to(['delete', 'id' => $model->id]);
                                                return Html::a(
                                                    '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                    '#',
                                                    [
                                                        'title' => Yii::t('yii', 'Delete'),
                                                        'aria-label' => Yii::t('yii', 'Delete'),
                                                        'onclick' => "deleteclick('".$url."');"
                                                    ]
                                                );
                                            
                                            return "";
                                        }
                                    ],
                                    'headerOptions' => ['style' => 'width:7%'],
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
