<?php

namespace admin\modules\productcategory\controllers;

use Yii;
use app\components\BaseController;
use admin\models\ProductCategoryBrandSearch;
use admin\components\LabelComponent;
use common\models\ProductCategoryBrand;
use common\components\ErrorGenerateComponent;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

/**
 * BrandController implements the CRUD actions for Project model.
 */
class BrandController extends BaseController
{
    public function actionIndex($id)
	{
		BaseController::$page_caption = 'Brand';

		$searchModel = new ProductCategoryBrandSearch();
        $searchModel->product_category_id = $id;
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider
        ]);
	}

	public function actionCreate($catid)
	{
        BaseController::$page_caption = 'Add Brand';

		$model = new ProductCategoryBrand();
        $model->product_category_id = $catid;
        
        if ($model->load(Yii::$app->request->post())) {
            
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->product_brand_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/categorybrands/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index', 'id' => $catid]);
            }
        }

        return $this->render('form', [
           'model' => $model,
        ]);
	}

    public function actionUpdate($id, $catid)
	{
        BaseController::$page_caption = 'Update Brand';

		$model = new ProductCategoryBrand();
        $model->product_category_id = $catid;
        
        if ($model->load(Yii::$app->request->post())) {
            
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->product_brand_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/categorybrands/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index', 'id' => $catid]);
            }
        }

        return $this->render('form', [
           'model' => $model,
        ]);
	}

	public function actionDelete($id, $catid)
	{
        $this->findModel($id)->delete();
        Yii::$app->session->setFlash('success', 'Brand '.LabelComponent::SUCCESS_DELETE);
        
        return $this->redirect(['index', 'id' => $catid]);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductCategoryBrand::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
