<?php

namespace admin\modules\productcategory\controllers;

use Yii;
use app\components\BaseController;
use common\models\ProductCategory;
use admin\models\ProductCategorySearch;
use admin\components\LabelComponent;
use common\components\ErrorGenerateComponent;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Product Category';

		$searchModel = new ProductCategorySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Product Category';

	    $model = new ProductCategory();
        $model->loadDefaultValues();

        $model->ajaxRequests();

        if ($model->load(Yii::$app->request->post())) {

            $model->product_category_slug = empty($model->product_category_slug) ? $model->slugify($model->product_category_name) : $model->slugify($model->product_category_slug);

            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->product_category_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/categories/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Product Category '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Product Category';

  		$model = $this->findModel($id);
        
        $model->ajaxRequests();

        if ($model->load(Yii::$app->request->post())) {

            $model->product_category_slug = empty($model->product_category_slug) ? $model->slugify($model->product_category_name) : $model->slugify($model->product_category_slug);

            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->product_category_image = $imageName.'.'.$model->image->extension;
            }

            if ($model->save()) {

                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/categories/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Product Category '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $model = $this->findModel($id);
        $model->is_deleted = 1;
        $model->update(false);

        Yii::$app->session->setFlash('success', 'Product Category '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the ProductCategory model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ProductCategory the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductCategory::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
