<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductCategoryBrand;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton(['id' => $model->product_category_id]);
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-content">
				<div class="card-body">
                    <?=$form->field($model, 'product_brand_name')->textInput(['class' => 'form-control input-sm'])?>
                    <label><?=(new ProductCategoryBrand)->getAttributeLabel('product_brand_image')?></label><br/>
                    <?= $form->field($model, 'image')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->product_brand_image)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/categorybrands/".$model->product_brand_image);
                            if(file_exists("../../uploads/categorybrands/".$model->product_brand_image)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
				</div>
			</div>
		</div>
	</div>
</section>
<?php ActiveForm::end(); ?>