<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use admin\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton(['catid' => $searchModel->product_category_id]);

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title"><?=$searchModel->productCategory->product_category_name?></h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="table-responsive">
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            'filterModel' => null,
                            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                'product_brand_name',
                                [
                                    'attribute' => 'product_brand_image',
                                    'format' => 'raw',
                                    'value' => function($model) {
                                        return '<img src="'.str_replace("/admin", "", Url::base(true)).'/uploads/categorybrands/'.$model->product_brand_image.'" style="max-width: 200px; max-height: 150px;" />';
                                        // return '<a href="'.str_replace("/admin", "", Url::base(true)).'/uploads/categorybrands/'.$model->product_brand_image.'" target="_blank">'.$model->product_brand_image."</a>";
                                    },
                                    'filter' => false,
                                ],
                                [
                                    'class' => 'yii\grid\ActionColumn',
                                    'header'   => 'Actions',
                                    'template' => '<div style="white-space: nowrap;">{update}{delete}</div>',
                                    'buttons'  => [
                                        'update' => function ($url, $model) {    
                                            $url = Url::to(['update', 'id' => $model->id, 'catid' => $model->product_category_id]);
                                            return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                        },
                                        'delete' => function ($url, $model) {
                                            $url = Url::to(['delete', 'id' => $model->id, 'catid' => $model->product_category_id]);
                                            return Html::a(
                                                '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                '#',
                                                [
                                                    'title' => Yii::t('yii', 'Delete'),
                                                    'aria-label' => Yii::t('yii', 'Delete'),
                                                    'onclick' => "deleteclick('".$url."');"
                                                ]
                                            );
                                        }
                                    ],
                                    'headerOptions' => ['style' => 'width:7%'],
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
