<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\DeliveryCostComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductCategory;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<input type="hidden" id="baseUrl" name="baseurl" value="<?=Url::base(true)?>/voucher/default">
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => true]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <label><?=(new ProductCategory)->getAttributeLabel('product_category_image')?></label><br/>
                    <?= $form->field($model, 'image')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->product_category_image)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/categories/".$model->product_category_image);
                            if(file_exists("../../uploads/categories/".$model->product_category_image)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                    <?=$form->field($model, 'product_category_name')->textInput(['class' => 'form-control input-sm'])?>
                    <?=$form->field($model, 'product_category_slug')->textInput(['class' => 'form-control input-sm'])?>
                    <?=$form->field($model, 'product_category_parent_id')->dropDownList(ArrayHelper::map(ProductCategory::find()->andWhere('product_category_parent_id IS NULL')->all(), 'id', 'product_category_name'), ['prompt' => 'This is a parent', 'class' => 'form-control input-sm'])?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>
<script type="text/javascript">
$(document).ready(function(){
	$("#productcategory-product_category_name").blur(function(){
        var title = $(this).val();
        if (title != "") {
            $.post('<?=Yii::$app->request->getAbsoluteUrl();?>', {'mode': 'generateslug', 'product_category_name': title}, function(response){
                $("#productcategory-product_category_slug").val(response);
            }, 'json');
        }
    });
});
</script>