<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use common\components\DateComponent;
use common\components\CurrencyComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\ProductCategory;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <div class="table-responsive">
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            'filterModel' => $searchModel,
                            'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                [
                                    'attribute' => 'product_category_image',
                                    'format' => 'raw',
                                    'value' => function($model) {
                                        return "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/categories/').$model->product_category_image."' alt='' style='max-width: 200px; max-height: 150px;'/>";
                                    },
                                    'filter' => false,
                                ],
                                'product_category_name',
                                'product_category_slug',
                                [
                                    'attribute' => 'product_category_parent_id',
                                    'value' => function($model){
                                        return isset($model->parent) ? $model->parent->product_category_name : "";
                                    },
                                    'filter' => ArrayHelper::map(ProductCategory::find()->andWhere('product_category_parent_id IS NULL')->all(), 'id', 'product_category_name')
                                ],
                                [
                                    'class' => 'yii\grid\ActionColumn',
                                    'header'   => 'Actions',
                                    'template' => '<div style="white-space: nowrap; margin-bottom: 5px;">{brand}{update}{delete}</div><div style="white-space: nowrap;">{image}{inventory}{copy}</div>',
                                    'buttons'  => [
                                        'brand' => function ($url, $model) {
                                            if (!empty($model->product_category_parent_id)) {
                                                $url = Url::to(['brand/index', 'id' => $model->id]);
                                                return Html::a('<span class="btn btn-outline-secondary btn-sm"><i class="la la-image"></i></span> ', $url, ['title' => 'Image']);
                                            }
                                            return "";
                                        },
                                        'update' => function ($url, $model) {    
                                            $url = Url::to(['update', 'id' => $model->id]);
                                            return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                        },
                                        'delete' => function ($url, $model) {
                                            $url = Url::to(['delete', 'id' => $model->id]);
                                            return Html::a(
                                                '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                '#',
                                                [
                                                    'title' => Yii::t('yii', 'Delete'),
                                                    'aria-label' => Yii::t('yii', 'Delete'),
                                                    'onclick' => "deleteclick('".$url."');"
                                                ]
                                            );
                                        }
                                    ],
                                    'headerOptions' => ['style' => 'width: 1%'],
                                ],
                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
