<?php

namespace admin\modules\slide\controllers;

use Yii;
use app\components\BaseController;
use app\components\MyArrayCheck;
use common\models\Slide;
use admin\components\DeliveryCostComponent;
use admin\models\SlideSearch;
use admin\components\LabelComponent;
use admin\components\StringComponent;
use yii\filters\VerbFilter;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;
use Imagine\Image\Box;


class DefaultController extends BaseController
{
    public function actionIndex()
	{
	    BaseController::$page_caption = 'Slide';

		$searchModel = new SlideSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

    public function actionCreate()
	{
        BaseController::$page_caption = 'Add Slide';

		$model = new Slide();
        $model->loadDefaultValues();
        $model->slide_order = $model->getLatestOrder() + 1;
        
        if ($model->load(Yii::$app->request->post())) {
           
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
              $model->slide_image_filename = $imageName.'.'.$model->image->extension;
            }

            $imageNameMobile = uniqid(rand());
            $model->imagemobile = UploadedFile::getInstance($model, 'imagemobile');
            if(!empty($model->imagemobile)){
              $model->slide_image_mobile_filename = $imageNameMobile.'.'.$model->imagemobile->extension;
            }

            $logoName = uniqid(rand());
            $model->logo = UploadedFile::getInstance($model, 'logo');
            if(!empty($model->logo)){
              $model->slide_image_logo_filename = $logoName.'.'.$model->logo->extension;
            }

            $iconName1 = uniqid(rand());
            $model->icon1 = UploadedFile::getInstance($model, 'icon1');
            if(!empty($model->icon1)){
              $model->slide_url_icon = $iconName1.'.'.$model->icon1->extension;
            }

            $iconName2 = uniqid(rand());
            $model->icon2 = UploadedFile::getInstance($model, 'icon2');
            if(!empty($model->icon2)){
              $model->slide_url_icon = $iconName2.'.'.$model->icon2->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                if(!empty($model->imagemobile)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/'.$imageNameMobile.'.'.$model->imagemobile->extension);
                    $model->imagemobile->saveAs($urlImage);
                }

                if(!empty($model->logo)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/logo/'.$logoName.'.'.$model->logo->extension);
                    $model->logo->saveAs($urlImage);
                }

                if(!empty($model->icon1)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/icon/'.$iconName1.'.'.$model->icon1->extension);
                    $model->icon1->saveAs($urlImage);
                }

                if(!empty($model->icon2)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/icon/'.$iconName2.'.'.$model->icon2->extension);
                    $model->icon2->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Slide '.LabelComponent::SUCCESS_SAVE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
           'model' => $model,
        ]);
	}

	public function actionUpdate($id)
	{
		BaseController::$page_caption = 'Update Slide';

		$model = $this->findModel($id);
  
        if ($model->load(Yii::$app->request->post())) {
           
            $imageName = uniqid(rand());
            $model->image = UploadedFile::getInstance($model, 'image');
            if(!empty($model->image)){
                $model->slide_image_filename = $imageName.'.'.$model->image->extension;
            }

            $imageNameMobile = uniqid(rand());
            $model->imagemobile = UploadedFile::getInstance($model, 'imagemobile');
            if(!empty($model->imagemobile)){
              $model->slide_image_mobile_filename = $imageNameMobile.'.'.$model->imagemobile->extension;
            }

            if ($model->save()) {
                if(!empty($model->image)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/'.$imageName.'.'.$model->image->extension);
                    $model->image->saveAs($urlImage);
                }

                if(!empty($model->imagemobile)){
                    $urlImage = str_replace('admin', '', Url::to('@app').'uploads/slides/'.$imageNameMobile.'.'.$model->imagemobile->extension);
                    $model->imagemobile->saveAs($urlImage);
                }

                Yii::$app->session->setFlash('success', 'Slide '.LabelComponent::SUCCESS_UPDATE);
                return $this->redirect(['index']);
            }
        }

        return $this->render('form', [
           'model' => $model,
        ]);
	}

    public function actionChangeorder($id, $type)
    {
        $model = $this->findModel($id);
        if ($type == 'up' && $model->slide_order > 1) {
            $slideBefore = Slide::find()->andWhere('slide_order < :order', [':order' => $model->slide_order])->orderBy(['slide_order' => SORT_DESC])->one();
            if ($slideBefore->slide_order == $model->slide_order - 1) {
                $slideBefore->slide_order = $model->slide_order;
                $slideBefore->save();
            }
            $model->slide_order--;
            $model->save();
        } else if ($type == 'down') {
            $slides = Slide::find()->all();
            if ($model->slide_order < count($slides)) {
                $slideAfter = Slide::find()->andWhere('slide_order > :order', [':order' => $model->slide_order])->orderBy(['slide_order' => SORT_ASC])->one();
                if ($slideAfter->slide_order == $model->slide_order + 1) {
                    $slideAfter->slide_order = $model->slide_order;
                    $slideAfter->save();
                }
                $model->slide_order++;
                $model->save();
            }
        }

        return $this->redirect(['index']);
    }

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();

        Yii::$app->session->setFlash('success', 'Slide '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    /**
     * Finds the Product model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Slide the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Slide::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
