<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use admin\components\LabelComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Slide;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);

$toolbar[] = ButtonComponent::getBackButton();
$toolbar[] = ButtonComponent::getSaveButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";

?>
<?php $form = ActiveForm::begin(['id' => 'application_form', 'enableClientValidation' => false]); ?>
<?php echo $form->errorSummary($model);?>
<section class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-content">
				<div class="card-body">
					<div class="row mb-1">
						<div class="col-md-6">
							<label><?=(new Slide)->getAttributeLabel('slide_image_filename')?></label><br/>
							<?= $form->field($model, 'image')->fileInput()->label(false) ?>
							<?php
								if(!empty($model->slide_image_filename)){
									$urlImage = str_replace("admin/", '', Url::base(true)."/uploads/slides/".$model->slide_image_filename);
									if(file_exists("../../uploads/slides/".$model->slide_image_filename)){
										echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
										echo "<i>Upload new image to replace this one</i>";
									}
								}
							?>
						</div>
						<div class="col-md-6">
							<label><?=(new Slide)->getAttributeLabel('slide_image_mobile_filename')?></label><br/>
							<?= $form->field($model, 'imagemobile')->fileInput()->label(false) ?>
							<?php
								if(!empty($model->slide_image_mobile_filename)){
									$urlImage = str_replace("admin/", '', Url::base(true)."/uploads/slides/".$model->slide_image_mobile_filename);
									if(file_exists("../../uploads/slides/".$model->slide_image_mobile_filename)){
										echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
										echo "<i>Upload new image to replace this one</i>";
									}
								}
							?>
						</div>
					</div>
                    <label><?=(new Slide)->getAttributeLabel('slide_image_logo_filename')?></label><br/>
                    <?= $form->field($model, 'imagemobile')->fileInput()->label(false) ?>
                    <?php
                        if(!empty($model->slide_image_logo_filename)){
                            $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/slides/logo/".$model->slide_image_logo_filename);
                            if(file_exists("../../uploads/slides/logo/".$model->slide_image_logo_filename)){
                                echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                echo "<i>Upload new image to replace this one</i>";
                            }
                        }
                    ?>
                    <br/><br/>
					<?=$form->field($model, 'slide_title')->textInput(['class' => 'form-control input-sm']);?>
					<?=$form->field($model, 'slide_color')->textInput(['class' => 'form-control input-sm']);?>
					<?=$form->field($model, 'slide_is_active')->dropDownList(['0' => 'Not Active', '1' => 'Active'], ['class' => 'form-control input-sm', 'prompt' => LabelComponent::CHOOSE_DROPDOWN])?>
                    <?=$form->field($model, 'slide_desc')->textInput(['class' => 'form-control input-sm tinymce']);?>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">URL</h4>
            </div>
            <div class="card-content">
                <div class="card-body pt-0">
                    <div class="row">
                        <div class="col-md-4">
                            <?=$form->field($model, 'slide_url')->textInput(['class' => 'form-control input-sm'])?>
                        </div>
                        <div class="col-md-4">
                            <?=$form->field($model, 'slide_url_label')->textInput(['class' => 'form-control input-sm'])?>
                        </div>
                        <div class="col-md-4">
                            <label><?=(new Slide)->getAttributeLabel('slide_url_icon')?></label><br/>
                            <?= $form->field($model, 'icon1')->fileInput()->label(false) ?>
                            <?php
                                if(!empty($model->slide_url_icon)){
                                    $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/slides/icon/".$model->slide_url_icon);
                                    if(file_exists("../../uploads/slides/icon/".$model->slide_url_icon)){
                                        echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                        echo "<i>Upload new image to replace this one</i>";
                                    }
                                }
                            ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <?=$form->field($model, 'slide_url2')->textInput(['class' => 'form-control input-sm'])?>
                        </div>
                        <div class="col-md-4">
                            <?=$form->field($model, 'slide_url_label2')->textInput(['class' => 'form-control input-sm'])?>
                        </div>
                        <div class="col-md-4">
                            <label><?=(new Slide)->getAttributeLabel('slide_url_icon2')?></label><br/>
                            <?= $form->field($model, 'icon2')->fileInput()->label(false) ?>
                            <?php
                                if(!empty($model->slide_url_icon)){
                                    $urlImage = str_replace("admin/", '', Url::base(true)."/uploads/slides/icon/".$model->slide_url_icon2);
                                    if(file_exists("../../uploads/slides/icon/".$model->slide_url_icon2)){
                                        echo Html::img($urlImage, ['style' => 'max-height: 200px'])."<br>";
                                        echo "<i>Upload new image to replace this one</i>";
                                    }
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php ActiveForm::end(); ?>
