<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\grid\GridView;
use admin\components\LabelComponent;
use admin\components\DateComponent;
use admin\components\ButtonComponent;
use app\components\BaseController;
use common\models\Category;

$this->title = BaseController::getCustomPageTitle(BaseController::$page_caption);
$toolbar[] = ButtonComponent::getAddButton();

BaseController::$toolbar = $toolbar;

foreach(Yii::$app->session->getAllFlashes() as $key => $message)
	echo '<div class="alert alert-' . $key . '">' . $message . "</div>\n";
?>
<section class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-content">
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= GridView::widget([
						        'dataProvider' => $dataProvider,
						        'filterModel' => $searchModel,
						        'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
						        'columns' => [
						            ['class' => 'yii\grid\SerialColumn'],
                                    [
										'attribute' => 'slide_image_filename',
										'format' => 'raw',
										'value' => function($model) {
											return "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/slides/').$model->slide_image_filename."' alt='' style='max-width: 200px; max-height: 150px;'/>";
										},
										'filter' => false,
									],
                                    [
										'attribute' => 'slide_image_mobile_filename',
										'format' => 'raw',
										'value' => function($model) {
											return "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/slides/').$model->slide_image_mobile_filename."' alt='' style='max-width: 200px; max-height: 150px;'/>";
										},
										'filter' => false,
									],
                                    [
										'attribute' => 'slide_image_logo_filename',
										'format' => 'raw',
										'value' => function($model) {
											return "<img src='".str_replace('/admin', '', Url::base(true).'/uploads/slides/logo/').$model->slide_image_logo_filename."' alt='' style='max-width: 200px; max-height: 150px;'/>";
										},
										'filter' => false,
									],
                                    'slide_title',
                                    [
                                        'attribute' => 'slide_desc',
                                        'format' => 'raw',
                                    ],
                                    [
                                        'attribute' => 'slide_color',
                                        'value' => function($model) {
                                            return '<div style="display: flex; align-items: center;"><div style="background-color: '.$model->slide_color.'; width: 20px; height: 20px; margin-right: 5px; border: 1px solid #000;"></div> <div style="color: '.$model->slide_color.'">'.$model->slide_color.'</div></div>';
                                        },
                                        'format' => 'raw',
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'slide_order',
                                        'filter' => false,
                                    ],
                                    [
                                        'attribute' => 'slide_is_active',
                                        'value' => function($model){
                                            return $model->slide_is_active == '1' ? 'Active' : 'Not Active';
                                        },
                                        'filter' => ['0' => 'Not Active', '1' => 'Active']
                                    ],
						            [
                                        'class' => 'yii\grid\ActionColumn',
                                        'header'   => 'Actions',
                                        'template' => '<div style="margin-bottom: 5px; white-space: nowrap;">{update}{delete}</div><div style="white-space: nowrap;">{up}{down}</div>',
                                        'buttons'  => [
                                            'up' => function ($url, $model) {
                                                $url = Url::to(['changeorder', 'id' => $model->id, 'type' => 'up']);
                                                return Html::a('<span class="btn btn-outline-primary btn-sm"><i class="la la-arrow-up"></i></span> ', $url, ['title' => 'Naik']);
                                            },
                                            'down' => function ($url, $model) {
                                                $url = Url::to(['changeorder', 'id' => $model->id, 'type' => 'down']);
                                                return Html::a('<span class="btn btn-outline-primary btn-sm"><i class="la la-arrow-down"></i></span> ', $url, ['title' => 'Turun']);
                                            },
                                            'update' => function ($url, $model) {
                                                    $url = Url::to(['update', 'id' => $model->id]);
                                                    return Html::a('<span class="btn btn-outline-warning btn-sm"><i class="la la-pencil"></i></span> ', $url, ['title' => 'Update']);
                                            },
                                            'delete' => function ($url, $model) {
                                                    $url = Url::to(['delete', 'id' => $model->id]);
                                                    return Html::a(
                                                        '<span class="btn btn-outline-danger btn-sm"><i class="la la-trash"></i></span>',
                                                        '#',
                                                        [
                                                            'title' => Yii::t('yii', 'Delete'),
                                                            'aria-label' => Yii::t('yii', 'Delete'),
                                                            'onclick' => "deleteclick('".$url."');"
                                                        ]
                                                    );
                                                
                                                return "";
                                            }
                                        ],
                                        'headerOptions' => ['style' => 'width:7%'],
                                    ],
						        ],
						    ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
