<?php

namespace admin\modules\subsidiary\controllers;

use Yii;
use app\components\BaseController;
use admin\models\SubsidiarySearch;
use admin\components\LabelComponent;
use common\models\Subsidiary;
use yii\web\NotFoundHttpException;
use yii\web\UploadedFile;
use yii\helpers\Url;

class DefaultController extends BaseController
{
    public function actionIndex()
	{
		BaseController::$page_caption = 'Subsidiary';

		$searchModel = new SubsidiarySearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel'  => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
	}

  	public function actionCreate()
	{
        BaseController::$page_caption = 'Add Subsidiary';

		$model = new Subsidiary;
        $model->subsidiary_order = $model->getLatestOrder() + 1;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Subsidiary '.LabelComponent::SUCCESS_SAVE);
            return $this->redirect(['index']);
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'create',
        ]);
	}

	public function actionUpdate($id)
	{
  		BaseController::$page_caption = 'Update Subsidiary';

  		$model = $this->findModel($id);
      
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Subsidiary '.LabelComponent::SUCCESS_UPDATE);
            return $this->redirect(['index']);
        }

        return $this->render('form', [
            'model' => $model,
            'mode' => 'update',
        ]);
	}

	public function actionDelete($id)
	{
        $this->findModel($id)->delete();
      
        Yii::$app->session->setFlash('success', 'Subsidiary '.LabelComponent::SUCCESS_DELETE);

        return $this->redirect(['index']);
	}

    public function actionChangeorder($id, $type)
    {
        $model = $this->findModel($id);
        if ($type == 'up' && $model->subsidiary_order > 1) {
            $subsidiaryBefore = Subsidiary::find()->andWhere('subsidiary_order < :order', [':order' => $model->subsidiary_order])->orderBy(['subsidiary_order' => SORT_DESC])->one();
            if ($subsidiaryBefore->subsidiary_order == $model->subsidiary_order - 1) {
                $subsidiaryBefore->subsidiary_order = $model->subsidiary_order;
                $subsidiaryBefore->save();
            }
            $model->subsidiary_order--;
            $model->save();
        } else if ($type == 'down') {
            $subsidiaries = Subsidiary::find()->all();
            if ($model->subsidiary_order < count($subsidiaries)) {
                $subsidiaryAfter = Subsidiary::find()->andWhere('subsidiary_order > :order', [':order' => $model->subsidiary_order])->orderBy(['subsidiary_order' => SORT_ASC])->one();
                if ($subsidiaryAfter->subsidiary_order == $model->subsidiary_order + 1) {
                    $subsidiaryAfter->subsidiary_order = $model->subsidiary_order;
                    $subsidiaryAfter->save();
                }
                $model->subsidiary_order++;
                $model->save();
            }
        }

        return $this->redirect(['index']);
    }

    /**
     * Finds the Subsidiary model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Subsidiary the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Subsidiary::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
