<?php 
namespace common\components;

use Yii;
use yii\base\Component; 

class CurrencyComponent extends Component
{
	public static function formatMoney($amount, $noLabel = "Rp", $decimals = 0, $decPoint = ",", $thousandSep = ".") 
	{
		return $noLabel.number_format($amount, $decimals, $decPoint, $thousandSep);
	}
	
	public function toWord($x) {
		$x = abs($x);
		$number = array("", "satu", "dua", "tiga", "empat", "lima",
		"enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
		$temp = "";
		if ($x <12) {
			$temp = " ". $number[$x];
		} else if ($x <20) {
			$temp = self::toWord($x - 10). " belas";
		} else if ($x <100) {
			$temp = self::toWord($x/10)." puluh". self::toWord($x % 10);
		} else if ($x <200) {
			$temp = " seratus" . self::toWord($x - 100);
		} else if ($x <1000) {
			$temp = self::toWord($x/100) . " ratus" . self::toWord($x % 100);
		} else if ($x <2000) {
			$temp = " seribu" . $this->toWord($x - 1000);
		} else if ($x <1000000) {
			$temp = self::toWord($x/1000) . " ribu" . self::toWord($x % 1000);
		} else if ($x <1000000000) {
			$temp = $this->toWord($x/1000000) . " juta" . self::toWord($x % 1000000);
		} else if ($x <1000000000000) {
			$temp = $this->toWord($x/1000000000) . " milyar" . self::toWord(fmod($x,1000000000));
		} else if ($x <1000000000000000) {
			$temp = self::toWord($x/1000000000000) . " trilyun" . self::toWord(fmod($x,1000000000000));
		}     
			return $temp;
	}
	 
	 
	public static function beCalculated($x, $style=4) {
		if($x<0) {
			$hasil = "minus ". trim($self::toWord($x));
		} else {
			$hasil = trim(self::toWord($x));
		}     
		switch ($style) {
			case 1:
				$hasil = strtoupper($hasil);
				break;
			case 2:
				$hasil = strtolower($hasil);
				break;
			case 3:
				$hasil = ucwords($hasil);
				break;
			default:
				$hasil = ucfirst($hasil);
				break;
		}     
		return $hasil;
	}
}