<?php
namespace common\components;

use Yii;
use yii\base\Component;

class DateComponent extends Component{

	const DATE_FORMAT = 'php:Y-m-d';
    const DATETIME_FORMAT = 'php:Y-m-d H:i:s';
    const TIME_FORMAT = 'php:H:i:s';


	public static function getHumanizedDate($date = NULL, $is_long = TRUE, $with_time = FALSE, $remove_year = FALSE, $remove_date = FALSE, $pm_am = TRUE)
	{
		if ($date == NULL) {
			$date = date('Y-m-d H:i:s');
		}

		if ($is_long === TRUE) {
			if ($with_time === TRUE) {
				if ($pm_am) {
					return date('d M Y, g:i A', strtotime($date));
				} else {
					return date('d F Y H:i:s', strtotime($date));
				}
			} else {
				$format = 'd F Y';
				if ($remove_year == TRUE) {
					$format = 'd F';
				} else {
					if ($remove_date) {
						$format = 'F Y';
					}
				}

				return date($format, strtotime($date));
			}
		} else {
			if ($with_time === TRUE) {
				if ($pm_am) {
					return date('d M Y, g:i A', strtotime($date));
				} else {
					return date('d F Y H:i:s', strtotime($date));
				}
			} else {
				$format = 'd-m-Y';
				if ($remove_year == TRUE) {
					$format = 'd-m';
				} else {
					if ($remove_date) {
						$format = 'm-Y';
					}
				}

				return date($format, strtotime($date));
			}
		}

		return $date;
	}

	public static function getHumanizedDateTime($date = NULL, $is_long = TRUE)
	{
		return self::getHumanizedDate($date, $is_long, TRUE);
	}

	public static function getArrOfMonth($month = '')
	{
		$arrOfMonth = array('1' => 'Januari', '2' => 'Febuari', '3' => 'Maret', '4' => 'April', '5' => 'Mei', '6' => 'Juni', '7' => 'Juli', '8' => 'Agustus', '9' => 'September', '10' => 'Oktober', '11' => 'November', '12' => 'Desember');
		return empty($month) ? $arrOfMonth : $arrOfMonth[$month];
	}

	public static function getYears($min, $max)
	{
		$arr = array();
		for($i=$min; $i<=$max; $i++) {
			$arr[$i] = $i;
		}
		return $arr;
	}

	public static function getDiffMonth($date, $differenceFormat = '%m', $dateCompare = null)
	{
		$dateCompare = $dateCompare === null ? $date : $dateCompare;
		$date1 = \DateTime::createFromFormat('Y-m-d',$date);
		$date2 = \DateTime::createFromFormat('Y-m-d',$dateCompare);
		$diff = date_diff($date1,$date2);
		return $date2 <= $date1 ? '0' : $diff->format($differenceFormat) ;
	}

    public static function convert($dateStr, $type='date', $format = null) {
        if ($type === 'datetime') {
              $fmt = ($format == null) ? self::DATETIME_FORMAT : $format;
        }
        elseif ($type === 'time') {
              $fmt = ($format == null) ? self::TIME_FORMAT : $format;
        }
        else {
              $fmt = ($format == null) ? self::DATE_FORMAT : $format;
        }
        return \Yii::$app->formatter->asDate($dateStr, $fmt);
    }

		public static function getIdDate($date){
			$bulan = array (
				1 =>   'Januari',
				'Februari',
				'Maret',
				'April',
				'Mei',
				'Juni',
				'Juli',
				'Agustus',
				'September',
				'Oktober',
				'November',
				'Desember'
			);
			$exp = explode('-', $date);

			return $exp[2] . ' ' . $bulan[ (int)$exp[1] ] . ' ' . $exp[0];
		}

		public static function getIdDay(){
			$hari = date ("D");

			switch($hari){
				case 'Sun':
					$hari_ini = "Minggu";
				break;

				case 'Mon':
					$hari_ini = "Senin";
				break;

				case 'Tue':
					$hari_ini = "Selasa";
				break;

				case 'Wed':
					$hari_ini = "Rabu";
				break;

				case 'Thu':
					$hari_ini = "Kamis";
				break;

				case 'Fri':
					$hari_ini = "Jumat";
				break;

				case 'Sat':
					$hari_ini = "Sabtu";
				break;

				default:
					$hari_ini = "Tidak di ketahui";
				break;
			}

			return $hari_ini;

		}

	public function getIdDayName($date)
	{
		$date = date("Y-m-d", strtotime($date));
		$parts = explode("-", $date);
		$dayForDate = date("N", mktime(0, 0, 0, $parts[1], $parts[2], $parts[0]));
		//$dayName = "";
		switch($dayForDate) {
			case 1: return 'Senin';
			case 2: return 'Selasa';
			case 3: return 'Rabu';
			case 4: return 'Kamis';
			case 5: return 'Jumat';
			case 6: return 'Sabtu';
			case 7: return 'Minggu';
		}
	}

	public function getIdDateFormat($date)
	{
		$date = date("Y-m-d", strtotime($date));
		$parts = explode("-", $date);
		$month = "";
		switch($parts[1]) {
			case 1: $month = "Januari"; break;
			case 2: $month = "Febuari"; break;
			case 3: $month = "Maret"; break;
			case 4: $month = "April"; break;
			case 5: $month = "Mei"; break;
			case 6: $month = "Juni"; break;
			case 7: $month = "Juli"; break;
			case 8: $month = "Agustus"; break;
			case 9: $month = "September"; break;
			case 10: $month = "Oktober"; break;
			case 11: $month = "November"; break;
			case 12: $month = "Desember"; break;
		}
		return $parts[2]." ".$month." ".$parts[0];
	}


	function humanTiming ($time)
	{

		$time = time() - $time; // to get the time since that moment
		$time = ($time<1)? 1 : $time;
		$tokens = array (
			31536000 => 'year',
			2592000 => 'month',
			604800 => 'week',
			86400 => 'day',
			3600 => 'hour',
			60 => 'minute',
			1 => 'second'
		);

		foreach ($tokens as $unit => $text) {
			if ($time < $unit) continue;
			$numberOfUnits = floor($time / $unit);
			return $numberOfUnits.' '.$text.(($numberOfUnits>1)?'s':'');
		}

	}
	
}
