<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_article".
 *
 * @property int $id
 * @property int $article_category_id
 * @property string $article_title
 * @property string $article_slug
 * @property string $article_featured_image
 * @property string $article_short_description
 * @property string $article_description
 * @property string $article_status
 * @property string|null $created_on
 * @property string|null $updated_on
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property int $is_deleted
 *
 * @property ArticleCategory $articleCategory
 */
class Article extends \common\models\MasterModel
{
    public $image;

    const STATUS_DRAFT = 'draft';
    const STATUS_PUBLISHED = 'published';

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_article';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['article_category_id', 'article_title', 'article_slug', 'article_featured_image', 'article_short_description', 'article_description'], 'required'],
            [['article_category_id', 'created_by', 'updated_by', 'is_deleted'], 'integer'],
            [['article_short_description', 'article_description', 'article_status'], 'string'],
            [['created_on', 'updated_on'], 'safe'],
            [['article_title', 'article_slug', 'article_featured_image'], 'string', 'max' => 255],
            [['article_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => ArticleCategory::className(), 'targetAttribute' => ['article_category_id' => 'id']],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'article_category_id' => 'Category',
            'article_title' => 'Title',
            'article_slug' => 'Slug',
            'article_featured_image' => 'Image',
            'image' => 'Image',
            'article_short_description' => 'Short Desc',
            'article_description' => 'Content',
            'article_status' => 'Status',
            'created_on' => 'Created On',
            'updated_on' => 'Updated On',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * Gets query for [[ArticleCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticleCategory()
    {
        return $this->hasOne(ArticleCategory::className(), ['id' => 'article_category_id']);
    }

    public function getStatusLabels($label='')
    {
        $labels = [
            self::STATUS_DRAFT => 'Draft',
            self::STATUS_PUBLISHED => 'Published'
        ];

        return $label == '' ? $labels : (isset($labels[$label]) ? $labels[$label] : "");
    }

    public function ajaxRequests()
    {
        if (isset($_POST['mode']) && $_POST['mode'] == 'generateslug' && $_POST['article_title'] != "") {
            echo json_encode((new Article)->slugify($_POST['article_title']));
            die();
        }
    }
}
