<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_article_category".
 *
 * @property int $id
 * @property string $category_name
 * @property string $category_color
 * @property int $is_deleted
 *
 * @property Article[] $articles
 */
class ArticleCategory extends \common\models\MasterModel
{
    public $image;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_article_category';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category_name', 'category_color', 'category_image'], 'required'],
            [['is_deleted'], 'integer'],
            [['category_name', 'category_color'], 'string', 'max' => 255],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'category_name' => 'Name',
            'category_color' => 'Color',
            'image' => 'Image',
            'category_image' => 'Image',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * Gets query for [[Articles]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticles()
    {
        return $this->hasMany(Article::className(), ['article_category_id' => 'id']);
    }
}
