<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_brand".
 *
 * @property int $id
 * @property string $brand_logo
 * @property int $brand_order
 */
class Brand extends \common\models\MasterModel
{
    public $image;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_brand';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['brand_order'], 'integer'],
            [['brand_logo'], 'string', 'max' => 255],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'brand_logo' => 'Logo',
            'brand_order' => 'Order',
        ];
    }

    public function getLatestOrder()
    {
        $brand = Brand::find()->orderBy(['brand_order' => SORT_DESC])->one();
        if (!empty($brand)) {
            return $brand->brand_order;
        }
        return 0;
    }
}
