<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_certification".
 *
 * @property int $id
 * @property string $certification_logo
 * @property string $certification_name
 */
class Certification extends \common\models\MasterModel
{
    public $image;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_certification';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['certification_logo', 'certification_name'], 'required'],
            [['certification_logo', 'certification_name'], 'string', 'max' => 255],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'certification_logo' => 'Logo',
            'certification_name' => 'Name',
        ];
    }
}
