<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_facility".
 *
 * @property int $id
 * @property string $facility_title
 * @property string $facility_desc
 */
class Facility extends \common\models\MasterModel
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_facility';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['facility_title', 'facility_desc'], 'required'],
            [['facility_desc'], 'string'],
            [['facility_title'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'facility_title' => 'Title',
            'facility_desc' => 'Desc',
        ];
    }
}
