<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_indo_distribution".
 *
 * @property int $id
 * @property string $dist_province_name
 * @property int $dist_col
 *
 * @property IndoDistributionDetail[] $indoDistributionDetails
 */
class IndoDistribution extends \common\models\MasterModel
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_indo_distribution';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['dist_province_name'], 'required'],
            [['dist_col'], 'integer'],
            [['dist_province_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'dist_province_name' => 'Province',
            'dist_col' => 'Num of col',
        ];
    }

    /**
     * Gets query for [[IndoDistributionDetails]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIndoDistributionDetails()
    {
        return $this->hasMany(IndoDistributionDetail::className(), ['indo_distribution_id' => 'id']);
    }
}
