<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_indo_distribution_detail".
 *
 * @property int $id
 * @property int $indo_distribution_id
 * @property string $dist_city_name
 *
 * @property IndoDistribution $indoDistribution
 */
class IndoDistributionDetail extends \common\models\MasterModel
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_indo_distribution_detail';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['indo_distribution_id', 'dist_city_name'], 'required'],
            [['indo_distribution_id'], 'integer'],
            [['dist_city_name'], 'string', 'max' => 255],
            [['indo_distribution_id'], 'exist', 'skipOnError' => true, 'targetClass' => IndoDistribution::className(), 'targetAttribute' => ['indo_distribution_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'indo_distribution_id' => 'Indo Distribution ID',
            'dist_city_name' => 'Dist City Name',
        ];
    }

    /**
     * Gets query for [[IndoDistribution]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getIndoDistribution()
    {
        return $this->hasOne(IndoDistribution::className(), ['id' => 'indo_distribution_id']);
    }
}
