<?php

namespace common\models;

use Yii;

/**
 * Class to put generic functions for all models
 *
 */
class MasterModel extends \yii\db\ActiveRecord
{
	const SCENARIO_INSERT = 'insert';
	const SCENARIO_UPDATE = 'update';
	const SCENARIO_DELETE = 'delete';
	const SCENARIO_REPORT = 'report';

	// Keyword to be used when filling filter for querying records with value null
	const CRITERIA_IS_NULL = ':kosong';

	// Whether or not to fill updated_on and updated_by on create
	protected $alwaysFillUpdateAttributes = false;

	public function beforeSave($insert)
	{
		date_default_timezone_set('Asia/Jakarta');
		if (parent::beforeSave($insert)) {
			if ($this->isNewRecord) {
				if ($this->hasAttribute('created_on')) {
					if(empty($this->created_on)){
						$this->created_on = date("Y-m-d H:i:s");
					}
				}
				if ($this->hasAttribute('created_by')) {
					$this->created_by = Yii::$app->user->id;
				}
			}
			if (!$this->isNewRecord || $this->alwaysFillUpdateAttributes) {
				if ($this->hasAttribute('updated_on')) {
					$this->updated_on = date("Y-m-d H:i:s");
				}
				if ($this->hasAttribute('updated_by')) {
					$this->updated_by = Yii::$app->user->id;
				}
			}
			return true;
		} else {
			return false;
		}
	}
	
	public function getMaxId($yearMonth, $field) 
	{
		$connection = \Yii::$app->db;
        $row = $connection->createCommand('SELECT MAX('.$field.') as mid FROM '.$this->tableName().' WHERE '.$field.' LIKE "%'.$yearMonth.'%"')->queryOne();
        if ($row['mid']) {
            return $row['mid'];
        } else {
            return 'false';
        }
    }
	
	public function getLatestNumber($field)
	{
		$parts = explode('-', date("d-m-y"));
		$yearMonth = $parts[2] . $parts[1] . $parts[0];
		$latestNumber = "";
        if ($this->getMaxId($yearMonth, $field) == 'false') {
            $latestNumber = $yearMonth . '001';
		}
		else {
			$id = (int) substr($this->getMaxId($yearMonth, $field), strlen($yearMonth)) + 1;
			$latestNumber = $yearMonth . str_pad($id, 3, 0, STR_PAD_LEFT);
		}
		
		return $latestNumber;
	}

	public function slugify($text)
    {
      	// replace non letter or digits by -
      	$text = preg_replace('~[^\pL\d]+~u', '-', $text);

      	// transliterate
      	$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

      	// remove unwanted characters
      	$text = preg_replace('~[^-\w]+~', '', $text);

      	// trim
      	$text = trim($text, '-');

      	// remove duplicate -
      	$text = preg_replace('~-+~', '-', $text);

      	// lowercase
      	$text = strtolower($text);

      	if (empty($text)) {
        	return NULL;
      	}

		return $text;
	}
}