<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_milestone".
 *
 * @property int $id
 * @property string $milestone_year
 * @property string $milestone_description
 * @property string $milestone_image
 * @property string $milestone_position
 * @property int $milestone_order
 */
class Milestone extends \common\models\MasterModel
{
    const POSITION_LEFT = 'left';
    const POSITION_RIGHT = 'right';

    public $image;
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_milestone';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['milestone_year', 'milestone_description', 'milestone_image', 'milestone_position'], 'required'],
            [['milestone_description', 'milestone_image', 'milestone_position'], 'string'],
            [['milestone_order'], 'integer'],
            [['milestone_year'], 'string', 'max' => 255],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'milestone_year' => 'Year',
            'milestone_description' => 'Description',
            'milestone_image' => 'Image',
            'milestone_position' => 'Position',
            'milestone_order' => 'Order',
        ];
    }

    public function getPositionLabel($label = '')
    {
        $labels = [
            self::POSITION_LEFT => 'Left',
            self::POSITION_RIGHT => 'Right',
        ];

        return $label == '' ? $labels : (isset($labels[$label]) ? $labels[$label] : "");
    }

    public function getLatestOrder()
    {
        $milestone = Milestone::find()->orderBy(['milestone_order' => SORT_DESC])->one();
        if (!empty($milestone)) {
            return $milestone->milestone_order;
        }
        return 0;
    }
}
