<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_product_category".
 *
 * @property int $id
 * @property int|null $product_category_parent_id
 * @property string $product_category_name
 * @property string|null $product_category_slug
 * @property string|null $product_category_image
 * @property int $is_deleted
 *
 * @property ProductCategory $productCategoryParent
 * @property ProductCategory[] $productCategories
 * @property ProductCategoryBrand[] $ProductCategoryBrands
 */
class ProductCategory extends \common\models\MasterModel
{
    public $image;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_product_category';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_category_parent_id', 'is_deleted'], 'integer'],
            [['product_category_name'], 'required'],
            [['product_category_name', 'product_category_slug', 'product_category_image'], 'string', 'max' => 255],
            [['product_category_parent_id'], 'exist', 'skipOnError' => true, 'targetClass' => ProductCategory::className(), 'targetAttribute' => ['product_category_parent_id' => 'id']],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product_category_parent_id' => 'Parent Category',
            'product_category_name' => 'Name',
            'product_category_slug' => 'Slug',
            'product_category_image' => 'Image',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * Gets query for [[ProductCategoryParent]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getParent()
    {
        return $this->hasOne(ProductCategory::className(), ['id' => 'product_category_parent_id']);
    }

    /**
     * Gets query for [[ProductCategories]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductCategories()
    {
        return $this->hasMany(ProductCategory::className(), ['product_category_parent_id' => 'id']);
    }

    /**
     * Gets query for [[ProductCategoryBrands]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductCategoryBrands()
    {
        return $this->hasMany(ProductCategoryBrand::className(), ['product_category_id' => 'id']);
    }

    public function ajaxRequests()
    {
        if (isset($_POST['mode']) && $_POST['mode'] == 'generateslug' && $_POST['product_category_name'] != "") {
            echo json_encode((new ProductCategory)->slugify($_POST['product_category_name']));
            die();
        }
    }
}
