<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_product_category_brand".
 *
 * @property int $id
 * @property int $product_category_id
 * @property string $product_brand_name
 * @property string $product_brand_image
 * @property int $is_deleted
 *
 * @property ProductCategory $productCategory
 */
class ProductCategoryBrand extends \common\models\MasterModel
{
    public $image;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_product_category_brand';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_category_id', 'product_brand_name', 'product_brand_image'], 'required'],
            [['product_category_id', 'is_deleted'], 'integer'],
            [['product_brand_image'], 'string'],
            [['product_brand_name'], 'string', 'max' => 255],
            [['product_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => ProductCategory::className(), 'targetAttribute' => ['product_category_id' => 'id']],
            [['image'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'product_category_id' => 'Category',
            'product_brand_name' => 'Name',
            'product_brand_image' => 'Image',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * Gets query for [[ProductCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductCategory()
    {
        return $this->hasOne(ProductCategory::className(), ['id' => 'product_category_id']);
    }
}
