<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_profile".
 *
 * @property int $profile_id
 * @property int $user_id
 * @property string $profile_name
 * @property string|null $profile_slug
 * @property string|null $profile_avatar
 * @property string|null $profile_gender
 * @property string|null $profile_address
 * @property string|null $profile_phone1
 * @property string|null $profile_phone2
 *
 * @property User $user
 */
class Profile extends \common\models\MasterModel
{
    const GENDER_MALE = 'm';
    const GENDER_FEMALE = 'f';
    public $image;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_profile';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'profile_name'], 'required'],
            [['user_id'], 'integer'],
            [['profile_gender', 'profile_address'], 'string'],
            [['profile_name', 'profile_slug', 'profile_avatar', 'profile_phone1', 'profile_phone2'], 'string', 'max' => 255],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::className(), 'targetAttribute' => ['user_id' => 'id']],
            ['image','file', 'extensions' => 'png,jpg,jpeg', 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'profile_id' => 'Profile ID',
            'user_id' => 'User',
            'profile_name' => 'Profile Name',
            'profile_slug' => 'Slug',
            'profile_avatar' => 'Photo',
            'profile_gender' => 'Gender',
            'profile_address' => 'Address',
            'profile_phone1' => 'Phone 1',
            'profile_phone2' => 'Phone 2',
            'image' => 'Photo',
        ];
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::className(), ['id' => 'user_id']);
    }

    public function getGenderLabels($label='')
    {
        $labels = [
            self::GENDER_MALE => 'Male',
            self::GENDER_FEMALE => 'Female',
        ];

        return $label == '' ? $labels : (isset($labels[$label]) ? $labels[$label] : "");
    }

    public function slugify($text)
    {
      // replace non letter or digits by -
      $text = preg_replace('~[^\pL\d]+~u', '-', $text);

      // transliterate
      $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

      // remove unwanted characters
      $text = preg_replace('~[^-\w]+~', '', $text);

      // trim
      $text = trim($text, '-');

      // remove duplicate -
      $text = preg_replace('~-+~', '-', $text);

      // lowercase
      $text = strtolower($text);

      if (empty($text)) {
        return 'n-a';
      }

      return $text;
    }
}
