<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_setting_category".
 *
 * @property int $id
 * @property string $category_name
 * @property string|null $created_on
 * @property string|null $updated_on
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property int $is_deleted
 *
 * @property TblSetting[] $tblSettings
 */
class SettingCategory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_setting_category';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category_name'], 'required'],
            [['created_on', 'updated_on'], 'safe'],
            [['created_by', 'updated_by', 'is_deleted'], 'integer'],
            [['category_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'category_name' => 'Category Name',
            'created_on' => 'Created On',
            'updated_on' => 'Updated On',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'is_deleted' => 'Is Deleted',
        ];
    }

    /**
     * Gets query for [[TblSettings]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTblSettings()
    {
        return $this->hasMany(TblSetting::className(), ['setting_category_id' => 'id']);
    }
}
