<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "tbl_slide".
 *
 * @property int $id
 * @property string $slide_title
 * @property string $slide_desc
 * @property string $slide_color
 * @property string $slide_image_filename
 * @property string $slide_image_mobile_filename
 * @property string $slide_image_logo_filename
 * @property string|null $slide_url
 * @property string|null $slide_url_label
 * @property string|null $slide_url_icon
 * @property string|null $slide_url2
 * @property string|null $slide_url_label2
 * @property string|null $slide_url_icon2
 * @property int $slide_order
 * @property int $slide_is_active
 */
class Slide extends \common\models\MasterModel
{
    public $image, $imagemobile, $logo, $icon1, $icon2;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tbl_slide';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['slide_title', 'slide_desc', 'slide_color', 'slide_image_filename', 'slide_image_mobile_filename', 'slide_image_logo_filename'], 'required'],
            [['slide_desc', 'slide_url', 'slide_url2'], 'string'],
            [['slide_order', 'slide_is_active'], 'integer'],
            [['slide_title', 'slide_color', 'slide_image_filename', 'slide_image_mobile_filename', 'slide_image_logo_filename', 'slide_url_label', 'slide_url_icon', 'slide_url_label2', 'slide_url_icon2'], 'string', 'max' => 255],
            [['image', 'imagemobile', 'logo', 'icon1', 'icon2'],'file', 'extensions' => 'png,jpg,jpeg', 'maxSize' => 1024 * 1024 * 2, 'skipOnEmpty' => true],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'slide_title' => 'Title',
            'slide_desc' => 'Desc',
            'slide_color' => 'Color',
            'slide_image_filename' => 'Image',
            'slide_image_mobile_filename' => 'Image (Mobile)',
            'slide_image_logo_filename' => 'Logo',
            'slide_url' => 'Url',
            'slide_url_label' => 'Url Label',
            'slide_url_icon' => 'Url Icon',
            'slide_url2' => 'Url 2',
            'slide_url_label2' => 'Url Label 2',
            'slide_url_icon2' => 'Url Icon 2',
            'slide_order' => 'Order',
            'slide_is_active' => 'Is Active',
            'image' => 'Image', 
            'imagemobile' => 'Image (Mobile)',
            'logo' => 'Logo',
            'icon1' => 'Url Icon', 
            'icon2' => 'Url Icon 2',
        ];
    }

    public function getLatestOrder()
    {
        $slide = Slide::find()->orderBy(['slide_order' => SORT_DESC])->one();
        if (!empty($slide)) {
            return $slide->slide_order;
        }
        return 0;
    }
}
